/*------------------------------------------------------------------------------*
 * File Name: ScriptWindow.c													*
 * Creation: CPY 7/30/05														*
 * Purpose: Script Window for LT commands				 						*
 * Copyright (c) OriginLab Corp.	2005										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 8/4/05 TIME_STAMP_PER_SESSEION_ONLY										*
 *	CPY 8/27/05 AUTO_COMPLETE_HOOK												*
 *	CPY 9/9/05 AUTO_COMPLETE_OBJ												*
 *	Jasmine 9/16/05 START_BY_RIGHT_ARROW										*
 *	CPY 9/18/05 XF_CMD_UPDATE_LIST_UPON_CHANGING_XF_NAME						*
 *	CPY 9/24/05 DEBUG_SHOW_AC_CLASS_ON_CMD_WND_TITLE							*
 *	Jasmine 09/26/05 AUTO_COMPLETE_POP_UP_MENU									*
 *  Iris 11/10/05 QA70-8278-P2 MAKE_CMD_WND_DOCKABLE							*
 *  Iris 11/10/05 QA70-8278-P4 TO_REMOVE_SYSTEM_OUTPUT_WND						*
 *	CPY 3/15/06 SPLITTER_INIT_NEEDED_TO_BE_CALLED_FROM_RESIZE					*
 *	Jasmine 03/24/06 QA70-7998 v8.0378 MOVE_TO_CMD_CONTROL_H					*
 *  Joe     4/17/06  SHOW_CURRENT_TIME                                          *   
 *  Joe  5/19/06  AUTOCOMPLETE_CONTROL_CLASS                                    *
 *	CPY 5/25/06 HIST_PANE_POSITION_RESTART_WHEN_CLOSE_FROM_CMD_BAR_X			*
 *  Joe  7/11/06  AUTOCOMPLETE_GLOBALFUNCTION_USED                              *
 *  Joe  7/18/06  UP_DOWN_KEY_SHOW                                              *   
 *  Iris 8/04/06 NOT_SHOW_AC_WHEN_CTRL_V										*
 * 	Joe  8/24/06    ADD_PREFENCE_ON_CONTEXT_MENU								*
 *	CPY 2/10/2007 CMD_WIN_BTN_ON_TOOLBAR_NOT_SHOWING_PROPER_STATUS				*
 *	TD 4-12-07 QA70-9603 OC_CONTROLLED_DIALOGBARS_AUTOLAUNCH_ON_ORIGIN_BEGIN	*
 *	EJP 2007-06-11 v8.0639 QA70-9389 MOVE_AUTOCOMPLETE_TO_VC					*
 *	CPY CPY 11/1/2007 QA70-10638 CMD_WND_OUTPUT_ERR_BY_DEFAULT					*
 *------------------------------------------------------------------------------*/
  
#include <Origin.h>
#include <Array.h>   ///Joe  7/11/06  AUTOCOMPLETE_GLOBALFUNCTION_USED
#include "DialogEx.h"
#include "XFunctionEx.h"

#include "SplitterControl.h"

/// EJP 2007-06-11 v8.0639 QA70-9389 MOVE_AUTOCOMPLETE_TO_VC
//#include "AutoComplete.h"
#define MOVE_OC_TO_VC_AUTOCOMPLETE
/// end MOVE_AUTOCOMPLETE_TO_VC

#include "OriginEvents.h"/// TD 4-12-07 QA70-9603 OC_CONTROLLED_DIALOGBARS_AUTOLAUNCH_ON_ORIGIN_BEGIN

#pragma _NOAUTOREMOVE    
///Joseph 03/24/2007 MOVE_CODES_FROM_OC_TO_WITHOUT_ANY_CHANGING
#ifdef 	MOVE_OC_TO_VC_AUTOCOMPLETE
#include <xfutils.h>



#define	ac_on_key	okxf_ac_on_key

#define	ac_init		okxf_ac_init

#define	ac_done_replacesel	okxf_ac_done_replacesel

#define	ac_get_helpinfo		okxf_ac_get_helpinfo

#else

#include "ac_utils.h"	///Joe  7/11/06  AUTOCOMPLETE_GLOBALFUNCTION_USED

#endif
///End MOVE_CODES_FROM_OC_TO_WITHOUT_ANY_CHANGING


#include "ScriptWindow.h"

enum {SW_CONSOLE, SW_MESSAGE};

#define DEBUG_MSG_STR_CHAR(__ClassName, __Index)	//printf("%s\t%c\n", __ClassName, __Index);
#define DEBUG_MSG_STR_NUM(__ClassName, __Index)	//printf("%s\t%d\n", __ClassName, __Index);

void HistoryControl::OnInit()
{  
	static BOOL s_bFirstTime = true; // per compile session, for user, this will be good enough, so when open/close LTSW repeatedly, should work as same session
	//CmdControl::OnInit();  not calling base class
	//bool bLoadOK = Load(); //CPY 8/3/05 KEY_UP_DOWN_BUFFER moved here so load first, then add data
	ColorOptions(CODEEDIT_PARSE_NO_C_COMMENT|CODEEDIT_PARSE_NO_KEY_WORDS);// TD 8-11-05 Disable some colors //|PARSE_NO_OPERATORS|PARSE_NO_QUOTED_STRINGS|PARSE_NO_CHARS
	bool bLoadOK = Load(STR_HISTORY_FILENAME); /// Iris 8/10/05 
	if(s_bFirstTime)
	{
		s_bFirstTime = false;
		///Joe  4/17/06  SHOW_CURRENT_TIME  show the current using the ShowCurrentTime function;
		//WriteLine();	
		//string 	strDate = STR_LT_COMMENT_PREFIX + "--" + getCurrentTime();
		//int 	index = WriteLine(strDate);
		////---- CPY 8/10/05 HISTROY_WIN_REPLACED_BY_CODE_EDIT
		///*
		//index = GetLineCount()-2; ///Iris 8/10/05 WriteLine always return true now
		//SetLineColor(index, COLOR_COMMENT);
		//*/
		//WriteLine();	//CPY 8/3/05 make date line with empty space before commands
		showCurrentTime();
		///End
	}
	int nLines = GetLineCount();
    LineScroll(-nLines, 0);  //--- Iris 8/04/05 SUPPORT_MULTI_LINE
	//---- CPY 8/5/05 HISTORY_LOG_INIT_TO_SHOW_END
	if(nLines > 30)
    	LineScroll(nLines - 20, 0);
    //----
     //GetCmdVecBuffer();///Joe  7/18/06  UP_DOWN_KEY_SHOW 
}


class ScriptWindowDlg;
static ScriptWindowDlg* s_pScriptWinDlg = NULL;
/// Iris 11/10/05 QA70-8278-P2 MAKE_CMD_WND_DOCKABLE
#define CMDWND_USE_DIALOG_BAR
#ifdef CMDWND_USE_DIALOG_BAR
static DialogBar s_CmdWndBar;
#endif
///End MAKE_CMD_WND_DOCKABLE

/// Iris 11/10/05 QA70-8278-P4 TO_REMOVE_SYSTEM_OUTPUT_WND
//#define SYSTEM_OUTPUT_TAB
///End TO_REMOVE_SYSTEM_OUTPUT_WND

class ScriptWindowDlg : public ResizeDialog
{
public:
	ScriptWindowDlg() : ResizeDialog(IDD_SCRIPT_WINDOW, "ODlg8")
	{
	}
	DWORD DoModalEx(HWND hParent)
	{
		InitMsgMap();// will be called from internal later
		int nRet = DoModal(hParent);
		if(IDOK == nRet)
		{
			return 1;
		}
		return 0;
	}
	virtual int  Create(HWND hParent = NULL)
	{
		InitMsgMap();
		//Launch the modeless dialog
		int nRet = ResizeDialog::Create(hParent);
		
		return nRet;
	}
protected:
	EVENTS_BEGIN
		ON_INIT(OnInitDialog)
		ON_READY(OnReady)
		ON_DESTROY(OnDestroy)
		ON_SIZE(OnDlgResize)
		ON_OK(OnOK)
		ON_SYSCOMMAND(OnSystemCommand)
#ifdef SYSTEM_OUTPUT_TAB
		ON_TAB_SEL_CHANGE(IDC_LTSW_TAB, OnTabChange)
		ON_EN_CHANGE(IDC_LTSW_MESSAGE, OnSystemWndChanged)  ///Iris 8/18/05 SHOW_SYSCMD_IF_IT_CHANGED
#endif //SYSTEM_OUTPUT_TAB	
		ON_GETMINMAXINFO(OnMinMaxInfo)
		ON_CONTEXTMENU(OnShowMenu)
		ON_IDLE(OnIdle)	//CPY 9/24/05 DEBUG_SHOW_AC_CLASS_ON_CMD_WND_TITLE
		ON_USER_MSG(WM_USER_DIALOGBAR_SHOW, OnShow)/// TD 6-5-06 QA70-8701 DDK_DIALOG_MSG_ON_HIDE_BAR
	EVENTS_END
public:
	void Write(LPCSTR lpcszMsg, BOOL bAddReturn)
	{
		//-----CPY CPY 11/1/2007 QA70-10638 CMD_WND_OUTPUT_ERR_BY_DEFAULT
		m_LTsplitter.Write(lpcszMsg, bAddReturn);
		//-----
	}
	/// TD 6-5-06 QA70-8701 DDK_DIALOG_MSG_ON_HIDE_BAR
	BOOL OnShow(BOOL bShow, uint nLParam)
	{
		/// TD 4-12-07 QA70-9603 OC_CONTROLLED_DIALOGBARS_AUTOLAUNCH_ON_ORIGIN_BEGIN
		RegisterDlgBarState("ScriptWindow", "StartScriptWindow", bShow);
		/// end OC_CONTROLLED_DIALOGBARS_AUTOLAUNCH_ON_ORIGIN_BEGIN
		//out_int("OnShow with bShow = ", bShow);
		return TRUE;
	}
	/// end DDK_DIALOG_MSG_ON_HIDE_BAR
#ifdef SYSTEM_OUTPUT_TAB	
	int SetActive(int nTab)
	{
		int nRet = moveControlsInsideTab(nTab);
		OnDlgResize(0, GetDlgExtent(false), GetDlgExtent(true));
		return nRet;
	}
#endif //SYSTEM_OUTPUT_TAB	

protected:
	BOOL OnInitDialog()
	{
		waitCursor junk;
		//Profiler jj;
		ResizeDialog::OnInitDialog(0, STR_DLG_NAME); // str for reg remembering dialog pos etc info
		
    	m_LTsplitter.Init(IDC_LTSW_BOX, *this, "CommandWindowSplitter");

    	///Jasmine 9/16/05 START_BY_RIGHT_ARROW
    	///Joe  8/24/06    ADD_PREFENCE_ON_CONTEXT_MENU
		//m_strAutoCompleteState = "AutoCompleteState";
		//m_nAutoCompleteState = LoadSetting(m_strAutoCompleteState, AUTOCOMPLETE_ON, STR_DLG_NAME);
		//m_LTsplitter.SetAutoCompleteState(m_nAutoCompleteState);
		///End ADD_PREFENCE_ON_CONTEXT_MENU
		///End
		
    	Text = STR_DLG_NAME;
    	
    	
    	return TRUE;
	}
	BOOL OnReady()
	{		
#ifdef SYSTEM_OUTPUT_TAB
		m_tabSW = GetItem(IDC_LTSW_TAB);
		m_tabSW.InsertItem(SW_CONSOLE, _L("LabTalk"));
		m_tabSW.InsertItem(SW_MESSAGE, _L("System Output"));
		
		m_reSysMessages = GetItem(IDC_LTSW_MESSAGE);
		m_reSysMessages.SetFont(ANSI_FIXED_FONT);
		m_reSysMessages.LimitText(500 * 1024); //500K might still need to make bigger later

		HWND hWnd = m_reSysMessages.GetSafeHwnd();
		if(hWnd)
			set_LT_script_window(hWnd);
    	m_reSysMessages.SendMessage(EM_SETEVENTMASK, 0, ENM_CHANGE);
#else //SYSTEM_OUTPUT_TAB
		//TD 09-21-2007 TAB_PAINTED_OVER_SPLITTER
		Control cTab = GetItem(IDC_LTSW_TAB);
		if(cTab)
			cTab.ShowWindow(SW_HIDE);
		//end TAB_PAINTED_OVER_SPLITTER	
#endif //SYSTEM_OUTPUT_TAB	
    	
    	m_LTsplitter.OnReady(); //CPY 9/22/05 SPLITTER_INIT_SIZE_ON_READY
///Iris 8/18/05 SHOW_SYSCMD_IF_IT_CHANGED
		SetInitReady();
		ShowDialog(false);
				
		LT_execute("@CWV=1"); //CPY 2/10/2007 CMD_WIN_BTN_ON_TOOLBAR_NOT_SHOWING_PROPER_STATUS

		return true;
	}
	BOOL OnIdle()//CPY 9/24/05 DEBUG_SHOW_AC_CLASS_ON_CMD_WND_TITLE
	{
		m_LTsplitter.OnIdle();
		return true;
	}
	BOOL OnOK()
	{
		return false;// do not close win
	}	
	BOOL OnDestroy(void)
	{
		///Jasmine 9/16/05 START_BY_RIGHT_ARROW
		///Joe  8/24/06    ADD_PREFENCE_ON_CONTEXT_MENU
		//m_nAutoCompleteState = m_LTsplitter.GetAutoCompleteState();
		//SaveSetting(m_strAutoCompleteState, m_nAutoCompleteState, STR_DLG_NAME);
		///End ADD_PREFENCE_ON_CONTEXT_MENU
		///End
		ResizeDialog::OnDestroy();				
		//m_LTsplitter.OnDestroy();
		
		LT_execute("@CWV=0"); //CPY 2/10/2007 CMD_WIN_BTN_ON_TOOLBAR_NOT_SHOWING_PROPER_STATUS
		
		//--- CPY 3/25/06 CMD_WIN_CANNOT_CLOSE_FROM_MAIN_TOOLBAR
		m_LTsplitter.OnDestroy();
		if(s_pScriptWinDlg)
		{
			delete this;
			s_pScriptWinDlg = NULL;
		}
		//---

		return true;
	}
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		if(!IsInitReady())
			return TRUE;

#ifdef SYSTEM_OUTPUT_TAB
		PositionControl(IDC_LTSW_TAB,0,0);
		SizeControl(IDC_LTSW_TAB, cx, cy);
		moveControlsInsideTab();
#else
		PositionControl(IDC_LTSW_BOX,0,0);
		SizeControl(IDC_LTSW_BOX, cx, cy);

#endif //SYSTEM_OUTPUT_TAB

		m_LTsplitter.OnDlgResize(nType, cx, cy); // CPY 3/15/06 SPLITTER_INIT_NEEDED_TO_BE_CALLED_FROM_RESIZE
		
		return TRUE;
	}
	BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny)
	{		
#ifdef SYSTEM_OUTPUT_TAB
		if(IDC_LTSW_MESSAGE == nResIDCtrl)
			return OnMessageMenu(nx, ny);
#endif //SYSTEM_OUTPUT_TAB	
		return FALSE;
	}
	
#ifdef SYSTEM_OUTPUT_TAB
	BOOL OnMessageMenu(int nx, int ny)
	{
		int				nCmd;
		MessageWndMenu	myMenu;
		myMenu.TrackPopupMenu(0,  nx, ny, GetSafeHwnd());
		if(myMenu.GetCommand(nCmd))
		{
			switch(nCmd)
			{				
			case MESSAGE_MENU_CLEAR:
				string str = m_reSysMessages.GetSelText();
				if(str.IsEmpty()) //clear all
				{			
					if(IDOK == MessageBox(GetSafeHwnd(), _L("Are you sure?"), STR_DLG_NAME, MB_OK|MB_OKCANCEL)) // --- Iris 8/08/05 SHOW_MB_BEFORE_CLEAR
						m_reSysMessages.Reset();
				}
				else
				{
					m_reSysMessages.ReplaceSel("");
					m_reSysMessages.SetSel(-1,-1);
				}
				return TRUE;
				break;
			case MESSAGE_MENU_PRINT:
				m_reSysMessages.Print(true, "System Message");
				break;
			}
		}
		return FALSE;
	}
#endif //SYSTEM_OUTPUT_TAB	


#ifdef SYSTEM_OUTPUT_TAB
	BOOL OnSystemWndChanged(Control oCntrl)
	{
		moveControlsInsideTab(SW_MESSAGE);
		return true;
	}
#endif //SYSTEM_OUTPUT_TAB

protected:	
#ifdef SYSTEM_OUTPUT_TAB
	void OnTabChange(Control cntrl)
	{
		int nType = m_tabSW.GetCurSel();
		moveControlsInsideTab(nType);
	}
#endif //SYSTEM_OUTPUT_TAB

private:
#ifdef SYSTEM_OUTPUT_TAB
	int moveControlsInsideTab(int nSetTab = -1)
	{
		int nRet = m_tabSW.GetCurSel();
		if(nSetTab < 0)
			nSetTab = nRet;
		else if(nSetTab != nRet)
		{
			m_tabSW.SetCurSel(nSetTab);
			nSetTab = m_tabSW.GetCurSel();
		}
		
		RECT rect;
		m_tabSW.GetWindowRect(&rect);
		ScreenToClient(&rect);
		m_tabSW.AdjustRect(FALSE, &rect);
		//InflateRect(&rect, -6,-8);  ///Iris 8/18/05, Leo said the border of the richedit is too thick
		InflateRect(&rect, -2,-3);
		if(nSetTab == SW_CONSOLE)
		{
			m_LTsplitter.MoveWindow(&rect);
			//m_LTsplitter.Visible = true;
			m_LTsplitter.SetShow();
			m_reSysMessages.Visible=false;
		}
		else
		{
			m_reSysMessages.Visible=false;
			m_reSysMessages.MoveWindow(&rect);
			m_reSysMessages.Visible=true;
			//m_LTsplitter.Visible = false;
			m_LTsplitter.SetShow(false);
		}
		return nRet;    
	}
#endif //SYSTEM_OUTPUT_TAB

private:
	TabControl 		m_tabSW;
#ifdef SYSTEM_OUTPUT_TAB
	RichEditEx		m_reSysMessages;
#endif //SYSTEM_OUTPUT_TAB
	LTSWSplitter	m_LTsplitter;
	///Jasmine 9/16/05 START_BY_RIGHT_ARROW
	string			m_strAutoCompleteState;
	int 			m_nAutoCompleteState;
	///End
};

/*
		if( s_pScriptWinDlg )
		{
			winDlg = s_pScriptWinDlg->GetWindow();
			if( winDlg )
				//winDlg.SendMessage(WM_CLOSE);
				DestroyWindow(winDlg.GetSafeHwnd());
			delete s_pScriptWinDlg;
			s_pScriptWinDlg = NULL;
		}
*/

/// Iris 11/10/05 QA70-8278-P2 MAKE_CMD_WND_DOCKABLE
static bool LTCmdBar(bool bClose=false)
{	
	Window winDlg;
	
	// if close
	if(bClose)
	{
#ifdef CMDWND_USE_DIALOG_BAR
		if(s_CmdWndBar)
			s_CmdWndBar.Destroy();
#else

#endif
		return true;
	}
	
	//---- CPY 5/25/06 HIST_PANE_POSITION_RESTART_WHEN_CLOSE_FROM_CMD_BAR_X
	if(s_bUserChangedHistoryPanePositionState)
		LTCmdBar(true);// close it so force to recreate
	s_bUserChangedHistoryPanePositionState = false;
	//----
	
	// Open or Make Visiable
	bool bCmdWndReady = false;
	if(NULL == s_pScriptWinDlg)
		s_pScriptWinDlg = new ScriptWindowDlg;
	else
		bCmdWndReady = true;
		

#ifdef CMDWND_USE_DIALOG_BAR
	if(s_CmdWndBar)
	{
		if(s_CmdWndBar.Visible)
			return true;
		if(bCmdWndReady)
		{
			if(!s_CmdWndBar.Visible) // then we should just make it visible
			{
				s_CmdWndBar.Visible = true;
				return true;
			}
		}
		LTCmdBar(true);
	}	
	//if(s_CmdWndBar.CreateControl(*s_pScriptWinDlg, "Command Window"))
	if(s_CmdWndBar.CreateControl(*s_pScriptWinDlg, STR_DLG_NAME)) /// Hong 11/07/07 v8.0742 MORE_LOCALIZED		
	{
		s_CmdWndBar.Visible = true;
	}
	else
	{
		return false;
	}
#else
/*
	winDlg = s_pScriptWinDlg->GetWindow();
	if(!winDlg)
		s_pScriptWinDlg->Create(GetWindow());
*/
#endif //CMDWND_USE_DIALOG_BAR


	return true;
}
///End MAKE_CMD_WND_DOCKABLE


int ScriptWindow(int nMsg = 0, DWORD dwCntrl = 0, LPVOID lpData = NULL)
{
	Window winDlg;
	switch(nMsg)
	{
	case OMSG_CLOSE:
		LTCmdBar(true);
		return 0;
		
	case OMSG_OPEN: // dwCntrl = 1 for message tab, 0 for LT tab
		if(NULL == s_pScriptWinDlg || !s_CmdWndBar.Visible)
			LTCmdBar(false);
		
		return 1;
		
	case OMSG_IS_VISIBLE:
		if(s_pScriptWinDlg && s_CmdWndBar.Visible)
		{
			Window winDlg = s_pScriptWinDlg->GetWindow();
			if(winDlg)
			{
				assign_HWND_to_PHWND(lpData, s_CmdWndBar.GetSafeHwnd());
				return 1;
			}
		}
		return 0;
	case OMSG_OUTPUT:
		if(s_pScriptWinDlg)
		{
			s_pScriptWinDlg->Write((LPCSTR)lpData, dwCntrl? true:false);
			return 1;
		}
		return 0;
	}
	return 0;
}


// in order to compile this file, you must close the command window, so use the following command
// you must issue this from Classic Script Window or from CodeBuilder LT console, never
// from inside Command Window
void cw_close(BOOL bClose = true)
{
	if(bClose)
		ScriptWindow(OMSG_CLOSE);
	else
		ScriptWindow(OMSG_OPEN);
		
}

///Joe  5/19/06  AUTOCOMPLETE_CONTROL_CLASS
/////////////////////////////////////////////////////////////////////////////////
/////////////////////////                                ////////////////////////
/////////////////////////the Class AutoCompleteControl   ////////////////////////
/////////////////////////                                ////////////////////////
/////////////////////////////////////////////////////////////////////////////////

	void AutoCompleteCmdControl::OnAutoCompleteClose(Window& wndToNotify, int nStart, int nEnd)
	{
		DebugMsg("OnAutoCompleteClose, this is not used anymore, please report to CP");
		//OnAutoComplete(-1, 0); // CPY 2nd arg = 0 to indicate called from VC level
		OnAutoComplete();// to close AutoComplete
		if(wndToNotify)
		{
			DebugMsg("wndToNotify ", nEnd);
			if(nStart > 0 && nEnd > nStart)
			{
				DebugMsg("auto complete text replaced, posting notification", nStart);
				wndToNotify.PostMessage(WM_USER_AUTOCOMPLETE_ON_REPLACE_SEL, nStart, nEnd);
			}
		}
	}

	bool AutoCompleteCmdControl::OnAutoCompleteDoneReplaceSel(int nStart, int nEnd)
	{
		///Joe  7/11/06  AUTOCOMPLETE_GLOBALFUNCTION_USED
		int nSelStart,nSelEnd;
		GetSel(nSelStart,nSelEnd);
		nEnd = nSelEnd;
		string strTempCmd = GetCmdLine();
		UINT nCharCmd = str_end_char(strTempCmd);
		if(ac_done_replacesel(nCharCmd))
		{
			OnAutoComplete(nStart, nEnd, CMDKEY_OPEN_AUTO_COMPLETE);
			return true;
		}
		//string strEnd = "- " + nEnd;
		//ACBase* pACobj = GetACObject();
		//if(pACobj)
		//{
			//
			//if(pACobj->IsImmediateStartNext())
			//{
				//// somehow nEnd is always same as nStart, so we will reget it 
				//int n1, n2;
				//GetSel(n1, n2);
				//nEnd = n2;
				//DebugMsg("IsImmediateStartNext is true, will start next ", nEnd, pACobj->GetClassName());
				//OnAutoComplete(nStart, nEnd, CMDKEY_OPEN_AUTO_COMPLETE);
				//return true;
			//}
		//}
		return false;
		///End AUTOCOMPLETE_GLOBALFUNCTION_USED
	}

	bool AutoCompleteCmdControl::OnAutoCompleteGetHelpInfo(int nIconID, LPCSTR lpcszSrc, string& strDisplay)
	{   
		///Joe  7/11/06  AUTOCOMPLETE_GLOBALFUNCTION_USED
		//ACBase* pACobj = GetACObject();
		//if(pACobj)
		//{
			////DebugMsg("OnAutoCompleteGetHelpInfo. icon", nIconID, pACobj->GetClassName());
			////---- Kevin 09/13/05 AUTO_COMPLETE_OBJ
			////strDisplay = pACobj->GetHelpInfo(lpcszSrc, nIconID);
			//string strCmd = GetCmdLine();
			//strDisplay = pACobj->GetHelpInfo(lpcszSrc, strCmd, nIconID);
			////---- end AUTO_COMPLETE_OBJ
			//return true;
		//}
		//DebugMsg("OnAutoCompleteGetHelpInfo found no AC obj Help Info");
		//return false;
		string strCmd = GetCmdLine();
		return ac_get_helpinfo(strCmd, nIconID, lpcszSrc, strDisplay);
		///End AUTOCOMPLETE_GLOBALFUNCTION_USED
	}

	void AutoCompleteCmdControl::OnAutoComplete(int nStart, int nCurrent, UINT nCharCmd)// = -1 = -1 = 0 
	{
		//if(!IsAutoCompleteOn())///Jasmine 09/26/05 AUTO_COMPLETE_POP_UP_MENU
		if(GetAutoCompleteState() != AUTOCOMPLETE_ON)
			return;
		m_nAutoCompleteStart = nStart;
		vector<string> saNames;
		vector<int> viAttributes;  		///Joe  7/11/06  AUTOCOMPLETE_GLOBALFUNCTION_USED
		if(!IsInAutoCompleteMode())
		{
			//SetStatusBarText(NULL, 1);
			if(nCurrent < 0)// indicate called from OC level, then tell VC level to close
				CloseAutoComplete();
			return;
		}
		string	strCmd = GetCmdLine();
		///Joe  7/11/06  AUTOCOMPLETE_GLOBALFUNCTION_USED
		//int     nAutoCompleteStart = -1;
		//bool	bImediateOpenAutoComplete = false;
		//bool	bOpenAutoComplete = false;
		//bool	bContinueUsingCurrentACobj = false; //---- CPY 9/18/05 XF_CMD_UPDATE_LIST_UPON_CHANGING_XF_NAME
		////ACBase* pACobj = GetACObject();
		//if(CMDKEY_OPEN_AUTO_COMPLETE == nCharCmd)
		//{
			////if(!pACobj)
				////return;	
			  //if(ac_is_empty())
			  	//return ;
			////DebugMsg("OnAutoComplete CMDKEY_OPEN_AUTO_COMPLETE", nStart, pACobj->GetClassName());
		//
			//bImediateOpenAutoComplete = true;
			//bOpenAutoComplete = true;
			////----- Kevin 09/12/05 need to get the whole CMD, not only the variable name;
		//}
		//else
		//{
			////---- CPY 9/18/05 XF_CMD_UPDATE_LIST_UPON_CHANGING_XF_NAME
			//// if(IsCharStartAutoComplete(nCharCmd))
			////if(pACobj && pACobj->IsUpdateListKey(nCharCmd))
			//if(ac_is_update_listkey( nCharCmd))
			//{
				//bContinueUsingCurrentACobj = true;
				////DebugMsg("OnAutoComplete IsUpdateListKey", nCurrent, pACobj->GetClassName());
			//}
			//
			//if(bContinueUsingCurrentACobj || ac_is_char_start( nCharCmd))
			////----
			//{
				////---- CPY 10/12/05 GET_NEXT_OBJ_NEEDS_TYPED_CHAR
				//// the following code can put junk into last char of strCmd, so we
				//// may need to improve this, or make sure subsequent code know about this problem
				//// this will happen when nCharCmd == VK_OEM_PLUS, VK_OEM_MINUS when user hit = or - key
				////-----
				//char szLast[2] = {0, 0};
				//szLast[0] = nCharCmd;
				//strCmd += szLast;
				////if(pACobj)
				  //if(! ac_is_empty() )
					//bOpenAutoComplete = true;
			//}
			//strCmd.TrimLeft();// temp, need better checking for operators etc later
			//strCmd.MakeLower();
		//}
		/////Joe  5/10/06  BACKSPACE_SHOW_AUTOCOPLETE
		//if(m_bAutoCompleteBackSpace)
		//{
			//ac_set_reset_obj( strCmd);
			////ACBase* pNextACobj = pACobj->GetResetACObj(strCmd);
			////SetACObject(pNextACobj);
		//}
		/////End BACKSPACE_SHOW_AUTOCOPLETE
		/////Joe  5/10/06  BACKSPACE_SHOW_AUTOCOPLETE
		////---- CPY 9/18/05 XF_CMD_UPDATE_LIST_UPON_CHANGING_XF_NAME
		////if(bOpenAutoComplete)
		////if(bOpenAutoComplete && !bContinueUsingCurrentACobj
		////----
		//if(bOpenAutoComplete && !bContinueUsingCurrentACobj  && !m_bAutoCompleteBackSpace)
		/////End BACKSPACE_SHOW_AUTOCOPLETE
		//{
			////ACBase* pNextACobj = pACobj->GetNextACObj(strCmd, nCharCmd);
			////if(!SetACObject(pNextACobj))
			////{
				////DebugMsg("SetACObject failed. ", 0, pACobj->GetClassName());
				////OnAutoComplete();// to close AutoComplete	
				////return;
			////}
			//if(! ac_set_next_obj( strCmd, nCharCmd))
				//return ;
			////DebugMsg("ready to start AutoComplete ", 0, pNextACobj->GetClassName());
		//}
		//m_bAutoCompleteBackSpace = false;
		//vector<int> viAttributes;
		////ACBase* pNewACobj = GetACObject();
		////DebugMsg("Class Name",0,pNewACobj->GetClassName());
		////if((pNewACobj->GetClassName()).Compare("ACXF") == 0)
		////strCmd.TrimRight();
		//
		////int nList = pNewACobj->GetDisplayList(strCmd, saNames, viAttributes);//, bSort);//strCmd, saNames, viAttributes, bSort);
		//bool IsRepFromPrompt = false;
		BOOL bSort = false;   ///Joe 8/14/06 Sort Error
		//int nList = ac_get_display_list( strCmd, saNames, viAttributes,bSort,IsRepFromPrompt);//, bool bSort,bool& IsRepFromPrompt = FALSE);
//
		//if(bImediateOpenAutoComplete)
		//{
			//nAutoCompleteStart = nCurrent;
		//}
		//else
		//{
			////if(pNewACobj->IsReplaceFromPrompt())
			////if(ac_is_replace_from_prompt())
			//if(IsRepFromPrompt)
				//nAutoCompleteStart = m_nPromptPosition;
			//else
				//nAutoCompleteStart = m_nPromptPosition + strCmd.GetLength();
		//}
		//
		//m_nAutoCompleteStart = nAutoCompleteStart;
		//DebugMsg("ready to start AutoComplete. ", nAutoCompleteStart, pNewACobj->GetClassName());
		///End AUTOCOMPLETE_GLOBALFUNCTION_USED
		bool bVariableListShow = true;
		int nList = ac_on_key(strCmd, nCharCmd, &m_bAutoCompleteBackSpace, nCurrent, m_nPromptPosition, &m_nAutoCompleteStart, &saNames, &viAttributes, &bVariableListShow);
		if(! bVariableListShow )
			return ;
		if(nList > 0)
			AutoComplete(m_nAutoCompleteStart, saNames, viAttributes, bSort);  ///Joe 8/14/06 Sort Error
		else
			CloseAutoComplete();
	}

    void AutoCompleteCmdControl::ResetAutoComplete()
	{
		///Joe  5/10/06  BACKSPACE_SHOW_AUTOCOPLETE 
		int nAutoCompleteStart = m_nAutoCompleteStart;
		OnAutoComplete(nAutoCompleteStart,nAutoCompleteStart,VK_BACK);
		m_nAutoCompleteStart = nAutoCompleteStart;
	
		//OnAutoComplete();
		//ACBase* pACobj = GetACObject();
		//if(pACobj)
		//{
			//DebugMsg("ResetAutoComplete currentn ACobj ", 0, pACobj->GetClassName());
			//string strCmd = GetCmdLine();
			
			//int nChar = str_end_char(strCmd);
			//DebugMsg("Cmd", nChar, strCmd);
			
			//ACBase* pNextACobj = pACobj->GetResetACObj(strCmd);
			//SetACObject(pNextACobj);
			//DebugMsg("ResetAutoComplete next ACobj ", 0, pNextACobj->GetClassName());
		//}
		//else
			//DebugMsg("ResetAutoComplete found NULL ACobj");	
		///End BACKSPACE_SHOW_AUTOCOPLETE 
	}
///Joe  7/11/06  AUTOCOMPLETE_GLOBALFUNCTION_USED
	//bool AutoCompleteCmdControl::IsCharStartAutoComplete(UINT nCharCmd)
	//{
		//if(m_pACobj)
		//{	
			//if(m_pACobj->IsUpdateListKey(nCharCmd))
				//return true;
			//return m_pACobj->IsNextStepKey(nCharCmd);
		//}
		// do not use this anymore, should all be decided by ACobj
		/*
		if( IsCharAlpha(nCharCmd) || ' ' == nCharCmd || '.' == nCharCmd || '_' == nCharCmd || '(' == nCharCmd)
		{
			// next test ACobj
				
			
			return true;
		}
		*/
		//return ac_is_char_start(  nCharCmd);
	//}

    //bool AutoCompleteCmdControl::SetACObject(ACBase* pACobj)
	//{
		//ClearAllACObjects();
		//m_pACobj = pACobj;
		//if (m_pACobj)
		//{
			//DebugMsg("set new AC class obj", 0, m_pACobj->GetClassName());
			//return true;
		//}
		//
		//DebugMsg("set AC class obj to NULL");
		//return false;
	//}
	///End AUTOCOMPLETE_GLOBALFUNCTION_USED
	bool AutoCompleteCmdControl::OnNotCmdKey(UINT msg, UINT wParam, UINT lParam, int nStart, int nEnd,int nSel)
	{//---- CPY 8/17/05 AUTO_COMPLETE_HOOK
			//if(IsAutoCompleteOn())///Jasmine 09/26/05 AUTO_COMPLETE_POP_UP_MENU
		if(GetAutoCompleteState() == AUTOCOMPLETE_ON)
		{
			if(wParam == VK_ESCAPE)
			{
				if(IsInAutoCompleteMode())
				{
					///Joe  5/10/06  BACKSPACE_SHOW_AUTOCOPLETE
					//ResetAutoComplete();// to close AutoComplete on Esc						
					OnAutoComplete();
					///End BACKSPACE_SHOW_AUTOCOPLETE
				}
				return true;// esc key will otherwise mess up dialog, so always eat it up
			}
			else if(msg == WM_KEYDOWN && REPOS_EDITABLE == nSel && IsAtEndOfLineNoSel(nStart, nEnd))
			{
				/// Iris 8/04/06 NOT_SHOW_AC_WHEN_CTRL_V
				if(wParam == VK_CONTROL || CNTRL_DOWN)
				{
					return false;
				}	
				///end NOT_SHOW_AC_WHEN_CTRL_V
				//if(IsCharStartAutoComplete(wParam)) ///Joe  7/11/06  AUTOCOMPLETE_GLOBALFUNCTION_USED
				CheckStartAutoComplete(wParam, nStart, nEnd);	
			}
		}
		return false;
	//----
	}
	
	void  AutoCompleteCmdControl::OnBackSpaceCmd(int nEnd)
	{
		///Joe 5/10/06  BACKSPACE_SHOW_AUTOCOPLETE
		//--- CPY 10/30/05 BACK_SPACE_TO_CLOSE_AND_RESET_AUTO_COMPLETE_WHEN_PASSED_STARTING_PT		
		//if(m_nAutoCompleteStart > m_nPromptPosition)
		//{
			//if(nEnd <= m_nAutoCompleteStart)
			//ResetAutoComplete();
		//}
		//---			
		if(m_nAutoCompleteStart >= m_nPromptPosition)
		{
			m_bAutoCompleteBackSpace = true; 
			//if(nEnd <= m_nAutoCompleteStart)  ///Joe  7/11/06  AUTOCOMPLETE_GLOBALFUNCTION_USED
				ResetAutoComplete();
		}
		///End BACKSPACE_SHOW_AUTOCOPLETE
		
	}
	
	bool  AutoCompleteCmdControl::OnLeftRightCmd(int nStart, int nEnd, UINT wParam)
	{
		if(nEnd <= m_nPromptPosition && wParam == VK_LEFT)
		{
			OnAutoComplete();
			return true;// eat up left key to prevent going pass prompt
		}		
		else if(AUTOCOMPLETE_BY_CMD == m_nAutoCompleteState && nEnd == nStart && IsAtEndOfLine(nEnd) && nEnd - m_nPromptPosition < 10 && VK_RIGHT == wParam)
		{
			SetAutoCompleteState(AUTOCOMPLETE_ON);
			OnAutoComplete(m_nPromptPosition, nStart, CMDKEY_OPEN_AUTO_COMPLETE);
			SetAutoCompleteState(AUTOCOMPLETE_BY_CMD);
			return true;
		}
	}
	
	bool AutoCompleteCmdControl::CheckStartAutoComplete(UINT nCharCmd, int nStart, int nEnd)
	{
		///Joe  7/11/06  AUTOCOMPLETE_GLOBALFUNCTION_USED
		//bool bTemp;
		//if( IsInAutoCompleteMode() )
		//{
			//OnAutoComplete(m_nAutoCompleteStart, -1, nCharCmd);
			//return true;
		//}
		//if(bTemp = IsCharStartAutoComplete(nCharCmd))
		//{
			//
			//OnAutoComplete(m_nPromptPosition, nStart, nCharCmd);
			//return true;
		//}
		//return false;
		int nAutoCompleteStart = m_nPromptPosition;
		int nAutoCompleteEnd = nEnd;
		if( IsInAutoCompleteMode() )
		{
			nAutoCompleteStart = m_nAutoCompleteStart;
			nAutoCompleteEnd = -1;
		}
		OnAutoComplete(nAutoCompleteStart, nAutoCompleteEnd, nCharCmd);
		
		return true;
		///End AUTOCOMPLETE_GLOBALFUNCTION_USED
	}
///Joe  5/19/06  AUTOCOMPLETE_CONTROL_CLASS

	
/// TD 4-12-07 QA70-9603 OC_CONTROLLED_DIALOGBARS_AUTOLAUNCH_ON_ORIGIN_BEGIN
// the following function is called by system on after startup build 
//to launch is the scripwindow was visible while closing origin
BOOL StartScriptWindow()
{
	cw_close(FALSE);
	return TRUE;
}
/// end OC_CONTROLLED_DIALOGBARS_AUTOLAUNCH_ON_ORIGIN_BEGIN
